// Sell.mq4
// 
#property copyright "mandorr@gmail.com"
#include <WinUser32.mqh>
extern double Lots=0.01;
extern int StopLoss=00;
extern int TakeProfit=00;
void start()
{
   if (!IsCondition()) return;
   int slippage=2;
   double loss=0  ; if (StopLoss  >0) loss  =Bid+StopLoss  *Point;
   double profit=0; if (TakeProfit>0) profit=Bid-TakeProfit*Point;
   OrderSend(Symbol(),OP_SELL,Lots,Bid,slippage,loss,profit,NULL,0,0,CLR_NONE);
   ShowError();
}
bool IsCondition()
{
   bool result=true;
   string field="     ";
   string msg;
   string title="";
   if (AccountNumber()>0) title=AccountNumber()+": "+title;
   if (!IsConnected())
   {
      msg=msg+"   "+field;
      result=false;
   }
   if (!IsTradeAllowed())
   {
      if (!result) msg=msg+"\n";
      msg=msg+" "+field;
      result=false;
   }
   double freemargin=AccountFreeMargin();
   if(freemargin<=0)
   {
      if (!result) msg=msg+"\n";
      msg=msg+"  "+field;
      result=false;
   }
   if (!result) MessageBox(msg,title,MB_OK|MB_ICONERROR);
   return (result);
}
void ShowError()
{
   string description;
   int err=GetLastError();
   switch (err)
   {
      case   0: return;
      case   1: description=" ,   "; break;
      case   2: description=" "; break;
      case   3: description=" "; break;
      case   4: description="  "; break;
      case   5: description="   "; break;
      case   6: description="    "; break;
      case   7: description=" "; break;
      case   8: description="  "; break;
      case   9: description="    "; break;
      case  64: description=" "; break;
      case  65: description="  "; break;
      case 128: description="    "; break;
      case 129: description=" "; break;
      case 130: description=" "; break;
      case 131: description=" "; break;
      case 132: description=" "; break;
      case 133: description=" "; break;
      case 134: description="    "; break;
      case 135: description=" "; break;
      case 136: description=" "; break;
      case 137: description=" "; break;
      case 138: description=" "; break;
      case 139: description="    "; break;
      case 140: description="  "; break;
      case 141: description="  "; break;
      case 145: description=" ,       "; break;
      case 146: description="  "; break;
      case 147: description="     "; break;
      default : description=" "; break;
   }
   string field="     ";
   string msg=" #"+err+" "+description+field;
   string title="";
   if (AccountNumber()>0)title=AccountNumber()+": "+title;
   MessageBox(msg,title,MB_OK|MB_ICONERROR);
}
// End